
  /*
   *  Object %CRYS_NVS.h   : %
   *  State           :  %state%
   *  Creation date   :  Tue Oct 30 09:29:27 2007
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version CRYS_NVS.c#1:csrc:1
   *  \author irab
   *  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
   *           All Rights reserved
   */



/************* Include Files ****************/
#ifdef SST_SEP_SIMULATOR_ENV
	#include "nvs_thread_duplicate_wrapper.h"
#endif 

#include "NVS.h"
#include "DX_VOS_Mem.h"
#include "DX_VOS_File.h"

/************************ Defines ******************************/
/************************ Enums ******************************/

/* number of elements in the array */
#define NVS_MAP_ARRAY_LEN 10

/************************ Typedefs ******************************/


/************************ Global Data ******************************/
/************* Private function prototype ****************/


static NVS_Mapping_t  s_MapArray[NVS_MAP_ARRAY_LEN];

/************************ Public Functions ******************************/

/* ************** TODO  need to be implemented by the user ********************** */
/* ************** TODO  need to be implemented by the user ********************** */
/**
 * @brief NVS_Init creates a mapping for the fileId input parameter. MemoryId is a token that defines the actual file.
 *        Each application that uses NVS associates the file(fileId) that it is working with , with the some token. 
 *        Application sees only the token, and the mapping between the token and the fileId will be done by NVS
 *        For example, the main storage of the SST may have the memoryId of 1 (that is how SST will see it), and the fileId will be 
 *        file descriptor of the actual file. when NVS recieves request from application , it will translate the memory Id into the file id.
 *
 * @param[in] fileId        - the fileId whose mapping to memory id will be returned in the memoryId_ptr.
 * @param[out] memoryId_ptr          - will hold the allocated memory id.
 *
 * @return DxError_t - On success the value DX_SUCCESS is returned, 
 *                     On failure the following values:
 *
 *                     NVS_MEMORY_ID_ALREADY_EXIST_ERROR - the memory id already exists
 *                     NVS_MEMORY_ALOCC_FAILURE - the buffers that holds the mapping is already full.
 */
DxError_t NVS_InitFile(DxUint32_t       fileId,
                       DxNvsMemoryId_t  memoryId)
{
  /* counter */
  DxUint32_t  counter;
 
  /* error */
  DxError_t   error;
   
  /*-----------------------
    CODE
  ---------------------------*/ 
  
  error = DX_SUCCESS;
  
  if(memoryId >= NVS_MAP_ARRAY_LEN)
  {
    error = NVS_MEMORY_ID_NOT_EXIST_ERROR;
    goto end_function;
  }
  
  /* set the mapping  - memory id is index into array, but from user point of view array start from 1*/
  s_MapArray[memoryId - 1].validFlag = 1;
  s_MapArray[memoryId - 1].fileId = fileId;
  
end_function:

  return error;
}

/* ************** TODO  need to be implemented by the user ********************** */
/**
 * @brief NVS_GetMemoryId returns the memory Id for the given file id. If mapping does not exists for the given file Id, then error is returned
 * @param[in] fileId        - the fileId whose mapped to memory idis required.
 * @param[out] memoryId_ptr          - will hold the found memory id.
 *
 * @return DxError_t - On success the value DX_SUCCESS is returned, 
 *                     On failure the following values:
 *
 *                     NVS_MEMORY_ID_ALREADY_EXIST_ERROR - the memory id already exists
 *                     NVS_MEMORY_ALOCC_FAILURE - the buffers that holds the mapping is already full.
 */                       
DxError_t NVS_GetMemoryId(DxUint32_t        fileId,
                          DxNvsMemoryId_t*  memoryId_ptr)
{
  /* error */
  DxError_t   error;
  
  /* count */
  DxUint32_t  count;
  
  /*--------------------------
      CODE
  ----------------------------*/
  
  error = DX_SUCCESS;
  
  for(count = 0; count < NVS_MAP_ARRAY_LEN; count++)
  {
    if(s_MapArray[count].fileId == fileId)
    {
      break;
    }
  }
  
  if(count >= NVS_MAP_ARRAY_LEN)
  {
    error = NVS_MEMORY_ID_NOT_EXIST_ERROR;
    goto end_function;
  }
  
  *memoryId_ptr = (count + 1);
  
end_function:

  return error;

}


/*NVS_Read*/
DxError_t NVS_Read(DxNvsMemoryId_t  memoryId,        /* the non volatile memory id - to this memory the NVS driver is accessing */
                   DxUint32_t       offset,               /*The source address in the non volatile memory where to copy the data from*/
                   char*            buffer_ptr,                /* Pointer to destination buffer. */
                   DxUint32_t       buff_len,             /* Number of Bytes to read from the Flash */
                   DxUint32_t*      bytes_read_ptr)      /* Number of bytes that are read */
{
  /* file id */
  DxUint32_t  fileId; 
  
  /* error */
  DxError_t   error; 
 
  /*---------------------
      CODE
  --------------------------*/
  
  error = DX_SUCCESS;
  
  if(memoryId >= NVS_MAP_ARRAY_LEN)
  {
    error = NVS_MEMORY_ID_NOT_EXIST_ERROR;
	  goto end_function;
  }
  
  fileId = s_MapArray[memoryId - 1].fileId;
	
  /* reading the data from the file */
  DX_VOS_FastMemCpy(buffer_ptr, 
                    (const void*)(fileId + offset), 
                    (DxUint_t)buff_len);
  
  *bytes_read_ptr = buff_len;

end_function:
    
  return error;

}/* END OF NVS_Read */  

/*NVS_Write*/
DxError_t NVS_Write(DxNvsMemoryId_t memoryId,        /* The non volatile memory id - to this memory the NVS driver is accessing */
                    DxUint32_t      offset,               /* The source address in the non volatile memory where to copy the data from*/
                    char*           buffer_ptr,                /* Pointer to destination buffer. */
                    DxUint32_t      buff_len,             /* Number of bytes to write to the memory */
                    DxUint32_t*     bytesWritten)        /* Number of bytes that were written */
{
  /* file id */
  DxUint32_t  fileId; 
  
  /* error */
  DxError_t   error; 
  
  /*------------------------
      CODE
  ------------------------------*/
  
  error = DX_SUCCESS;
  
  if(memoryId >= NVS_MAP_ARRAY_LEN)
  {
    error = NVS_MEMORY_ID_NOT_EXIST_ERROR;
	  goto end_function;
  }
  
  fileId = s_MapArray[memoryId - 1].fileId;
  
  /* writing the data to the file */
  DX_VOS_FastMemCpy((void*)(offset + fileId), 
                    buffer_ptr, 
                    (DxUint_t)buff_len);
  
  *bytesWritten = buff_len;
  
end_function:
  
  return error;

}/* END OF NVS_Write */


